#include <stdio.h>
#include <stdlib.h>
#include "matrix.h"


int solve_few_linear_eq( Matrix A, Vector c, Vector *x)
{
	
//	int n,m;
	float mA[N][N];
	float invA[N][N];	

	if(A.rows>A.cols)
	{
		printf("Error: 'ROWS > COLUMNS' \n");
		return 0;
	}
	Vector vectors[A.cols];
	for(int i=0;i<A.cols;i++)
	{
		vectors[i].elements=(float *)malloc(A.rows*sizeof(float));

		for(int j=0;j<A.rows;j++)
		vectors[i].elements[j]=A.elements[j][i];
		vectors[i].dim=A.rows;
	}
	
	
	int basis= dim_basis(vectors,A.cols);
//	printf("\nRANK = %d\n",basis);
	if(basis != A.rows)
	{
		printf("Error: Rank is %d [not 'N']\n",basis);
		return 0;
	}	
	basis = 1;
	for(int i=1;i<A.cols;i++)
	{
		if(check_vector_dep(vectors,basis,vectors[i]))
		{
			vectors[basis]=vectors[i];
			basis++;
		}

	}
	
	for(int i=0;i<A.rows;i++)
	{
		for(int j=0;j<basis;j++)
		{
			mA[i][j] = vectors[j].elements[i];
//			printf("%5.2f\t",vectors[j].elements[i]);

		}
//		printf("\n");
	}

	inv_matrix(mA,invA,basis);
		
//	output_matrix("Inverse Square Matrix\n",invA, basis,basis);
	x->dim = basis;
	for(int i=0;i<basis;i++)
	{
		float sum=0.0;
		for(int j=0;j<basis;j++)
		sum+=invA[i][j]*c.elements[j];
//		printf("X[%d] = %5.2lf\n",i,sum);
		x->elements[i]=sum;

	}
	return 1;

}
